local assets=
{
	Asset("ANIM", "anim/estus_full.zip"),
	Asset("ATLAS", "images/inventoryimages/estus_full.xml"),
	
}

local prefabs=
{

}

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("estus_full")
    inst.AnimState:SetBuild("estus_full")
    inst.AnimState:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/estus_full.xml"
    --inst:AddComponent("tradable")

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(5)
    inst.components.finiteuses:SetUses(5) 
	
    inst:AddComponent("edible")
    inst.components.edible.foodtype = "FLASK"
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = 0

	local ActionsEat_old = ACTIONS.EAT.fn
	ACTIONS.EAT.fn = function(act)
		local obj = act.target or act.invobject
		if act.doer.components.eater and obj and obj.components.edible then
			if obj.prefab=="estus_full" then
				local useAmount = obj.components.finiteuses:GetUses()
				if (useAmount > 1) then --Decrease finiteuses and give potion bonuses
					obj.components.finiteuses:Use(1)
					act.doer.components.health:DoDelta(35)
					act.doer.components.sanity:DoDelta(10)
					return true         --Return true so the character doesnt say "can't do that"
				elseif (useAmount == 1) then
					obj.components.finiteuses:Use(1)
					act.doer.components.inventory:GiveItem(SpawnPrefab("estus_empty"))
					act.doer.components.health:DoDelta(35)
					act.doer.components.sanity:DoDelta(10)
					return act.doer.components.eater:Eat(obj) --Here we allow the game to consume the item as normal
				end
			else
				return act.doer.components.eater:Eat(obj) --Not our item, do normal stuff
    		end
   	end
end

    return inst
end

return Prefab( "common/inventory/estus_full", fn, assets, prefabs)









